//~~~~~~~~~~~~~~~~~~~~//~~~~~~~~~~~~~~~~~~~~//~~~~~~~~~~~~~~~~~~~~//
//
// FIRE
//
//~~~~~~~~~~~~~~~~~~~~//~~~~~~~~~~~~~~~~~~~~//~~~~~~~~~~~~~~~~~~~~//

// fire particle
datablock ParticleData(fire_P)
{
  animTexName[0]       = "~/data/effects/effecttextures/flame1.png";
  animTexName[1]       = "~/data/effects/effecttextures/flame2.png";
  animTexName[2]       = "~/data/effects/effecttextures/flame3.png";
  animTexName[3]       = "~/data/effects/effecttextures/flame4.png";
  animTexName[4]       = "~/data/effects/effecttextures/flame5.png";
  animTexName[5]       = "~/data/effects/effecttextures/flame6.png";
  animateTexture       = true;
  framesPerSec         = 8;
  useInvAlpha          = true;
  allowLighting        = false;
  dragCoefficient      = 0;
  gravityCoefficient   = 0;
  windCoefficient      = 0;
  inheritedVelFactor   = 0;
  constantAcceleration = 0;
  spinRandomMin        = 0;
  spinRandomMax        = 0;
  lifetimeMS           = 1050;
  lifetimeVarianceMS   = 0;
  colors[0]            = "1.0 1.0 1.0 .8";
  colors[1]            = "1.0 1.0 1.0 1.0";
  colors[2]            = "1.0 1.0 1.0 1.0";
  colors[3]            = "1.0 1.0 1.0 0.8";
  sizes[0]             = 2.2;
  sizes[1]             = 2.3;
  sizes[2]             = 2.3;
  sizes[3]             = 2.2;
  times[0]             = 0.0;
  times[1]             = 0.1;
  times[2]             = 0.95;
  times[3]             = 1.0;
};

// fire emitter
datablock ParticleEmitterData(FireParticleEmitterData)
{
   particles = "fire_P";

   ejectionOffset = 0.0;
   ejectionPeriodMS = 1000;
   periodVarianceMS = 0;
   ejectionVelocity = 0;
   velocityVariance = 0;

   fadeColor = true;
   fadeSize = false;
   emitterType = "vector";
   spreadMin = 0;
   spreadMax = 0;
   vector = "vector";

};

datablock afxEffectWrapperData(FireEffectWrapperData1)
{
  effect = FireParticleEmitterData;
  orientConstraint = "testEffect";

  delay       = 0;
  fadeInTime  = 0;
  fadeOutTime = 0;
};

//------------------------------------------------
// Small Fire
//------------------------------------------------

// fire particle
datablock ParticleData(smallfire_P)
{
  animTexName[0]       = "~/data/effects/effecttextures/smallflame1.png";
  animTexName[1]       = "~/data/effects/effecttextures/smallflame2.png";
  animTexName[2]       = "~/data/effects/effecttextures/smallflame3.png";
  animTexName[3]       = "~/data/effects/effecttextures/smallflame4.png";
  animTexName[4]       = "~/data/effects/effecttextures/smallflame5.png";
  animTexName[5]       = "~/data/effects/effecttextures/smallflame6.png";
  animateTexture       = true;
  framesPerSec         = 8;
  useInvAlpha          = true;
  allowLighting        = false;
  dragCoefficient      = 0;
  gravityCoefficient   = 0;
  windCoefficient      = 0;
  inheritedVelFactor   = 0;
  constantAcceleration = 0;
  spinRandomMin        = 0;
  spinRandomMax        = 0;
  lifetimeMS           = 1050;
  lifetimeVarianceMS   = 0;
  colors[0]            = "1.0 1.0 1.0 1.0";
  colors[1]            = "1.0 1.0 1.0 1.0";
  colors[2]            = "1.0 1.0 1.0 1.0";
  colors[3]            = "1.0 1.0 1.0 1.0";
  colors[3]            = "1.0 1.0 1.0 1.0";
  sizes[0]             = 2;
  sizes[1]             = 2.2;
  sizes[2]             = 2.2;
  sizes[3]             = 2.1;
  times[0]             = 0.0;
  times[1]             = 0.1;
  times[2]             = 0.95;
  times[3]             = 1.0;
};

// fire emitter
datablock ParticleEmitterData(smallFireParticleEmitterData)
{
   particles = "smallfire_P";

   ejectionOffset = 0.0;
   ejectionPeriodMS = 1000;
   periodVarianceMS = 0;
   ejectionVelocity = 0;
   velocityVariance = 0;

   fadeColor = true;
   fadeSize = false;
   emitterType = "vector";
   spreadMin = 0;
   spreadMax = 0;
   vector = "vector";

};

datablock afxEffectWrapperData(smallFireEffectWrapperData1)
{
  effect = smallFireParticleEmitterData;
  orientConstraint = "testEffect";

  delay       = 0;
  fadeInTime  = 0;
  fadeOutTime = 0;
};

//~~~~~~~~~~~~~~~~~~~~//~~~~~~~~~~~~~~~~~~~~//~~~~~~~~~~~~~~~~~~~~//
//
// Sparks
//
//~~~~~~~~~~~~~~~~~~~~//~~~~~~~~~~~~~~~~~~~~//~~~~~~~~~~~~~~~~~~~~//

// firespark particle
datablock ParticleData(spark_P)
{
	textureName          = "~/data/effects/effecttextures/LMF_spark";
  animateTexture       = false;
  useInvAlpha          = false;
  allowLighting        = true;
	dragCoefficient      = 0.6;
  gravityCoefficient   = "-0.5";
  windCoefficient      = 0.3;
  inheritedVelFactor   = 0;
  constantAcceleration = 0;
  spinRandomMin        = 10;
  spinRandomMax        = 30;
	lifetimeMS           = 1200;
  lifetimeVarianceMS   = 100;
  colors[0]            = "1.0 1.0 1.0 1.0";
  colors[1]            = "1.0 1.0 1.0 0.8";
  colors[2]            = ".6 .5 .24 0.4";
  colors[3]            = "0.25 .12 .02 0";
  sizes[0]             = 0.4;
  sizes[1]             = 0.3;
  sizes[2]             = 0.2;
  sizes[3]             = 0.2;
  times[0]             = 0.0;
  times[1]             = 0.3;
  times[2]             = 0.6;
  times[3]             = 1.0;
};

// fire emitter
datablock ParticleEmitterData(SparkParticleEmitterData)
{
   particles = "spark_P";

   ejectionOffset = 0.0;
   ejectionPeriodMS = 350;
   periodVarianceMS = 10;
   ejectionVelocity = 1;
   velocityVariance = .5;
   fadeColor = false;
   fadeSize = false;
	 emitterType = "cone";
	 spreadMin = 1;
	 spreadMax = 5;

	 vector = "vector";

};
datablock afxEffectWrapperData(sparkEffectWrapperData1)
{
  effect = SparkParticleEmitterData;
  orientConstraint = "testeffect";
  delay       = 0;
  fadeInTime  = 0;
  fadeOutTime = 0;
};
// Main Fire
datablock afxEffectronData(FireEffectronData)
{
  duration = $AFX::INFINITE_TIME;
  addEffect = FireEffectWrapperData1;
  addEffect = sparkEffectWrapperData1;
};
// Small Fire
datablock afxEffectronData(SmallFireEffectronData)
{
  duration = $AFX::INFINITE_TIME;
  addEffect = SmallFireEffectWrapperData1;
  addEffect = sparkEffectWrapperData1;
};


// Main Spark
datablock afxEffectronData(sparkEffectronData)
{
  duration = $AFX::INFINITE_TIME;
  addEffect = sparkEffectWrapperData1;
};

// SPLASH

datablock ParticleData(splash_P)
{
   canSaveDynamicFields = "1";
   dragCoefficient = "0";
   windCoefficient = "0";
   gravityCoefficient = "0.35";
   inheritedVelFactor = "0";
   constantAcceleration = "0";
   lifetimeMS = "1925";
   lifetimeVarianceMS = "100";
   spinSpeed = "0.02";
   spinRandomMin = "-78";
   spinRandomMax = "145";
   animateTexture = "0";
   framesPerSec = "1";
   textureName = "assets/data/effects/effecttextures/splash.png";
   animTexName[0] = "assets/data/effects/effecttextures/splash.png";
   colors[0] = "1 1 1 0";
   colors[1] = "1 1 1 0.7";
   colors[2] = "1 1 1 0.4";
   colors[3] = "1 1 1 0";
   sizes[0] = "0.5";
   sizes[1] = "1.5";
   sizes[2] = "2.5";
   sizes[3] = "2";
   times[0] = "0";
   times[1] = "0.35";
   times[2] = "0.75";
   times[3] = "1";
   useInvAlpha  = true;
   allowLighting = false;
   constrainPos = "0";
};
datablock ParticleEmitterData(splashParticleEmitterData)
{
   canSaveDynamicFields = "1";
   className = "ParticleEmitterData";
   receiveLMLighting = "1";
   ejectionPeriodMS = "25";
   periodVarianceMS = "0";
   ejectionVelocity = "3";
   velocityVariance = "0";
   ejectionOffset = "0";
   ejectionDistance = "0";
   thetaMin = "0";
   thetaMax = "0";
   phiReferenceVel = "0";
   phiVariance = "360";
   overrideAdvance = "0";
   orientParticles = "0";
   orientOnVelocity = "1";
   particles = "splash_P\twater_P";
   lifetimeMS = "200";
   lifetimeVarianceMS = "0";
   useEmitterSizes = "0";
   useEmitterColors = "0";
   emitterType = "vector";
   ejectionInvert = "0";
   fadeColor = "0";
   fadeSize = "0";
   fadeVelocity = "0";
   fadeOffset = "0";
   vector = "0 1 0";
   spreadMin = "0";
   spreadMax = "0";
   pathOrigin = "origin";
   radiusMin = "0";
   radiusMax = "1";
};
datablock afxEffectWrapperData(splashEffectWrapperData)
{
  effect = splashParticleEmitterData;
  orientConstraint = "testEffect";

  delay       = 0;
  fadeInTime  = 0;
  fadeOutTime = 0;
};

datablock afxEffectronData(douseEffectronData)
{
  duration = $AFX::INFINITE_TIME;
  addEffect = splashEffectWrapperData;
};

// Health Kit Healing Effect

datablock ParticleData(healthplus_P)
{
   canSaveDynamicFields = "1";
   dragCoefficient = "0";
   windCoefficient = "0";
   gravityCoefficient = "-0.3";
   inheritedVelFactor = ".1";
   constantAcceleration = ".1";
   lifetimeMS = "1400";
   lifetimeVarianceMS = "100";
   spinSpeed = "0";
   spinRandomMin = "0";
   spinRandomMax = "0";
   useInvAlpha = "1";
   animateTexture = "0";
   framesPerSec = "1";
   textureName = "assets/data/effects/effecttextures/healthplus.png";
   animTexName[0] = "assets/data/effects/effecttextures/healthplus.png";
   colors[0] = "1 1 1 0";
   colors[1] = "1 1 1 0.9";
   colors[2] = "1 1 1 0.4";
   colors[3] = "1 1 1 0";
   sizes[0] = "0.5";
   sizes[1] = "1";
   sizes[2] = "1.5";
   sizes[3] = "0.8";
   times[0] = "0";
   times[1] = "0.35";
   times[2] = "0.75";
   times[3] = "1";
   allowLighting = "0";
   constrainPos = "0";
};
datablock ParticleEmitterData(healingParticleEmitterData)
{
   canSaveDynamicFields = "1";
   className = "ParticleEmitterData";
   receiveLMLighting = "1";
   ejectionPeriodMS = "55";
   periodVarianceMS = "0";
   ejectionVelocity = "1";
   velocityVariance = "0";
   ejectionOffset = "0";
   ejectionDistance = "0";
   thetaMin = "0";
   thetaMax = "180";
   phiReferenceVel = "0";
   phiVariance = "360";
   overrideAdvance = "0";
   orientParticles = "0";
   orientOnVelocity = "1";
   particles = "healthplus_P";
   lifetimeMS = "150";
   lifetimeVarianceMS = "0";
   useEmitterSizes = "0";
   useEmitterColors = "0";
   emitterType = "disc";
   ejectionInvert = "0";
   fadeColor = "0";
   fadeSize = "0";
   fadeVelocity = "0";
   fadeOffset = "0";
   vector = "0 0 1";
   spreadMin = "0";
   spreadMax = "1.5";
   pathOrigin = "origin";
   radiusMin = "0";
   radiusMax = "1.5";
};
datablock afxEffectWrapperData(healingEffectWrapperData)
{
  effect = healingParticleEmitterData;
  orientConstraint = "testEffect";

  delay       = 0;
  fadeInTime  = 0;
  fadeOutTime = 0;
};

datablock afxEffectronData(healingEffectronData)
{
  duration = $AFX::INFINITE_TIME;
  addEffect = healingEffectWrapperData;
};

datablock ParticleEmitterNodeData(DefaultParticleEmitterNodeData)
{
   timeMultiple = 1;
};
